# Contributing to TableFilter
:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

## Reporting bugs
Bugs are tracked as [GitHub issues](https://guides.github.com/features/issues/). 
Create an issue and provide the following information.

Explain the problem and include additional details to help maintainers reproduce 
the problem:

* **Use a clear, concise and descriptive title** for the issue to identify the 
problem.
* **Describe the exact steps which reproduce the problem** in as many details 
as possible.
* **Provide specific examples to demonstrate the steps**. Include links to 
files or GitHub projects, or copy/pasteable snippets, which you use in those 
examples. If you're providing snippets in the issue, use 
[Markdown code blocks](https://guides.github.com/features/mastering-markdown/#GitHub-flavored-markdown).
Do not paste large snippets completely unrelated to the issue. 
* **Describe the behavior you observed after following the steps** and point 
out what exactly is the problem with that behavior.
* **Explain which behavior you expected to see instead and why.**
* Do not hesitate to **include screenshots and animated GIFs** which show you 
following the described steps and clearly demonstrate the problem.
You can use [this tool](http://www.cockos.com/licecap/) to record GIFs on macOS 
and Windows, and [this tool](https://github.com/colinkeenan/silentcast) or 
[this tool](https://github.com/GNOME/byzanz) on Linux.

### Template for submitting bug reports

    [Short description of problem here]

    **Reproduction steps:**

    1. [First Step]
    2. [Second Step]
    3. [Other Steps...]

    **Expected behavior:**

    [Describe expected behavior here]

    **Observed behavior:**

    [Describe observed behavior here]

    **Screenshots and GIFs**

    ![Screenshots and GIFs which follow reproduction steps to demonstrate the 
    problem](url)

    **TableFilter version:** [Enter TableFilter version here]
    **Browser and version:** [Enter Browser name and version here]
    **OS and version:** [Enter OS name and version here]

    **Additional information:**

    * Problem started happening recently, didn't happen in an older version of 
    TableFilter: [Yes/No]
    * Problem can be reliably reproduced, doesn't happen randomly: [Yes/No]

## Suggesting enhancements and features
Enhancement and feature suggestions are tracked as 
[GitHub issues](https://guides.github.com/features/issues/). 
Create an issue and provide the following information:

* **Use a clear and descriptive title** for the issue to identify the 
suggestion.
* **Provide a step-by-step description of the suggested enhancement/feature** 
in as many details as possible.
* When applicable **describe the current behavior** and 
**explain which behavior you expected to see instead** and why.
* **Include screenshots and animated GIFs** which help you demonstrate the 
steps or point out the part of TableFilter which the suggestion is related to. 
You can use [this tool](http://www.cockos.com/licecap/) to record GIFs on macOS 
and Windows, and [this tool](https://github.com/colinkeenan/silentcast) or 
[this tool](https://github.com/GNOME/byzanz) on Linux.
* **Explain why this enhancement would be useful** to most TableFilter users.

### Template for submitting enhancement and feature suggestions

    [Short description of suggestion]

    **Steps which explain the enhancement/feature**

    1. [First Step]
    2. [Second Step]
    3. [Other Steps...]

    **Current and suggested behavior**

    [Describe current and suggested behavior here]

    **Why would the enhancement be useful to most users**

    [Explain why the enhancement would be useful to most users]

    **Screenshots and GIFs**

    ![Screenshots and GIFs which demonstrate the steps or part of TableFilter 
    the enhancement suggestion is related to](url)

    **TableFilter Version:** [Enter TableFilter version here]
    **Browser and version:** [Enter Browser name and version here]
    **OS and version:** [Enter OS name and version here]

## Code contribution
TableFilter welcomes contributions from anyone and everyone. If you want to get
your hands dirty:

### Pull requests
In general, we follow the "fork-and-pull" Git workflow.

 1. **Fork** the repo on GitHub
 2. **Clone** the project to your own machine
 3. **Commit** changes to your own branch 
    - 3.1. **Add** unit tests covering your change in the `test` folder
    - 3.2. **Run** the tests with the `npm run eslint test` command
    - 3.3. **Ensure** build is working with `npm run dist` command
 4. **Push** your work back up to your fork
 5. Submit a **Pull request** so that we can review your changes

NOTE: Be sure to merge the latest from "upstream" before making a pull request!

## Donations
Support this project by donating [here](http://www.tablefilter.com/donate.html).
Thanks to all those who supported this project in the past and those who will
in the future!
