<?php
// This demo creates a new BCH address from your xPub to be used as a 1-time payment address.
// It then prints the address along with a QR code containing the payiment URI.
include 'cashp/cashp.php'; // uncomment this if you are not using Composer


// user variables
$xPub = "xpub6DHdimMBY9N7rToFjNqv2KqVbFk7BUXGt7qTp2UuuSXHQTLkUmKSi8qcLNsJEfqoxu7qZ4y8DbunfGr2j5uEQZFj3G9663VhnzmSftW4zFa";
$requestAmountBCH = 0.002;
$addressCounter = 20; // increment this and store it (in database) to generate unique addresses

use Ekliptor\CashP\BlockchainApi\AbstractBlockchainApi;
use Ekliptor\CashP\BlockchainApi\Http\BasicHttpAgent;
use Ekliptor\CashP\CashP;
use Ekliptor\CashP\CashpOptions;

// setup library
$cashpOptions = new CashpOptions();
$cashpOptions->httpAgent = new BasicHttpAgent(function (string $subject, $error, $data = null) {
	// immplementing logger functions is optional. If omitted, all errors will be printed to stdOut
	echo "HTTP error: " . $subject;
});

$cashp = new CashP($cashpOptions);
AbstractBlockchainApi::setLogger(function (string $subject, $error, $data = null) {
	echo "BCH API error: " . $subject;
});

// now you can use the API (mutliple calls possible)
$address = $cashp->getBlockchain()->createNewAddress($xPub, $addressCounter);
print_r($address);

echo ($address);

?>